/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.parsing.ast;

import beaver.Symbol;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseNode;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParseRootNode
extends ParseNode
implements IParseRootNode {
    private IParseNode[] fComments;

    protected ParseRootNode(Symbol[] children) {
        IParseNode[] parseNodes;
        int start = 0;
        int end = 0;
        if (children == null || children.length == 0) {
            parseNodes = NO_CHILDREN;
        } else {
            List<IParseNode> nodes = this.filterParseNodesList(children);
            int nodesLen = nodes.size();
            if (nodesLen == 0) {
                parseNodes = NO_CHILDREN;
            } else {
                parseNodes = nodes.toArray(new IParseNode[nodesLen]);
                start = ((Symbol)parseNodes[0]).getStart();
                end = ((Symbol)parseNodes[nodesLen - 1]).getEnd();
            }
        }
        this.initialize(parseNodes, start, end);
    }

    public ParseRootNode(Symbol[] children, int start, int end) {
        List<IParseNode> nodes = this.filterParseNodesList(children);
        this.initialize(nodes.toArray(new IParseNode[nodes.size()]), start, end);
    }

    private List<IParseNode> filterParseNodesList(Symbol[] children) {
        int len = children.length;
        ArrayList<IParseNode> nodes = new ArrayList<IParseNode>(len);
        int i = 0;
        while (i < len) {
            Symbol child = children[i];
            if (child instanceof IParseNode) {
                nodes.add((IParseNode)child);
            }
            ++i;
        }
        return nodes;
    }

    private void initialize(IParseNode[] children, int start, int end) {
        this.start = start;
        this.end = end;
        this.setChildren(children);
        this.fComments = NO_CHILDREN;
    }

    @Override
    public IParseNode[] getCommentNodes() {
        return this.fComments;
    }

    public void setCommentNodes(IParseNode[] comments) {
        this.fComments = comments;
    }
}

